//
//  RequestTool.h
//  G-live
//
//  Created by leo on 2016/12/26.
//  Copyright © 2016年 陈伯伦. All rights reserved.
//
typedef void (^ReturnBlock)(NSDictionary *responseDic);

#import <Foundation/Foundation.h>
#import <GSCommonKit/GSReachability.h>
#import <RtSDK/RtSDK.h>
@interface RequestTool : NSObject
+ (instancetype)sharedInstance;

/**
  静态获取网络状态
  */
+ (GSNetworkStatus)getNetStatus;


/**
 POST请求
 @param domain
 @param parama 参数
 @param returnBlock 返回的数据
 */
- (void)requestWithDomain:(NSString *)domain parama:(NSDictionary *)parama returnBlock:(ReturnBlock)returnBlock;
/**
 POST请求
 @param domain
 @param parama 参数
 @param returnBlock 返回的数据
 */
- (void)refreshRequestWithDomain:(NSString *)domain parama:(NSDictionary *)parama returnBlock:(ReturnBlock)returnBlock;
  
/**
 *  通过webcastID获取roomNumber
 *
 *  @param webcastID  webcastID
 *  @param domain     域名
 *  @param completion 获取的结果
 */
- (void)fetchRoomNumberWithWebCastID:(nonnull NSString*)webcastID domain:(nonnull NSString*)domain completion:(void (^ __nullable)( NSString * _Nullable roomNumber, GSFetchRoomNumberResult result))completion;


    
/**
  取消所有的任务
 */
- (void)cancelRequest;


/**
 获取硬件UID
 @return
 */
+ (NSString *)getDeviceUID;



/**
 秒数转化为时间

 @param timeStr 秒数
 @return 字符串时间
 */
+ (NSString *)ConvertStrToTime:(NSString *)timeStr;


/**
 MD5加密
 @param str
 @return 
 */
+ (NSString *)stringToMD5:(NSString *)str;



//获取最终显示的title
+ (NSString *)getFinalTitleWithTitle:(NSString *)title andLength:(NSInteger)purposLength;



//获取存储的打赏信息
- (NSMutableArray *)getmodel:(NSArray *)arr;


//字符串编码
+(NSString*)nickNameUrlEncode:(NSString*)nickName;


/**
 上报日志
 @param uploadResultBlock 上报结果Block
 */
-(void)reportDiagonseWithBlock:(void(^)(GSDiagnosisType type,NSString* errorDescription))uploadResultBlock;


/**
 跳转在线客服
 */
-(void)onlineServiceWebUrl;




@end
